from httplib2 import Http
import json


def respuesta(estado, respuesta, dato=None):
    return {'Estado':estado,
            'Respuesta':respuesta,
            'Dato':dato}


async def enviar_mensaje_del_usuario(telefono_origen, telefono_destino, mensaje, nombre,
                               hora_mensaje, host, clase):
    """
    funcion para el envio de un mensaje DEL USUARIO AL SERVIDOR

    'Si se recibe el error: No se pudieron obtener los par\xe1metros del
    tel\xe9fono +54 9 3413 19-9175. Hay que revisar la tabla telefonos_api
    y poner la ip de donde está atmsj.

    Tambien verificar que -phone nro_empresa este puesto.'

    :param telefono_origen:
    :param telefono_destino:
    :param mensaje:
    :param nombre:
    :return:
    """

    url = host + '/nuevo_mensaje'

    dic = {}

    dic['telefono_origen'] = telefono_origen  # numero del usuario
    dic['telefono_destino'] = telefono_destino  # numero del cliente
    dic['mensaje'] = mensaje
    dic['clase'] = clase
    dic['nombre'] = nombre  # nombre del usuario
    dic['hora_mensaje'] = hora_mensaje

    return enviar(url, "POST", dic)


def obtener_mensajes_del_cliente(tel_cliente, host):
    """
    funcion que le pide los mensajes al servidor, (de un telefono de cliente (radiotaxi))
    para poder enviarle al usuario que pide el servicio

    :param tel_cliente: el telefono del radiotaxi
    :return: dict
                    ['Estado'] (bool)
                    ['Respuesta'] (str)

    """

    # que funcion voy a llamar
    url = host + '/msj/obtener_msj_para_enviar'

    dic = {}

    dic['telefono'] = tel_cliente

    rta = enviar(url, "POST", dic)

    return rta


def enviar(url, metodo, dic):
    # se desactivan los certificados
    http = Http(disable_ssl_certificate_validation=True)

    # convierto en json el diccionario
    parametros = json.dumps(dic)

    headers = {'Content-type': 'application/x-www-form-urlencoded'}  # cabecera
    try:
        resp, content = http.request(
            url, metodo, headers=headers, body=parametros
        )
    except Exception as error:
        print('error al enviar:', error)
        return respuesta(False, u"error al enviar msjs de atapis para enviar %s" % error)

    rta = json.loads(content.decode('utf-8'))

    return rta
