import asyncio
import aiosqlite
import os

import pandas as pd

from estaticos.esquema_bd import *

RUTA_BD = f"{os.getcwd()}/atwsp.db"


async def crear_bd_async():
    conexion = await aiosqlite.connect(RUTA_BD)

    return conexion


async def crear_tabla(conexion, tabla, **campos):
    '''
    Funcion que se encarga de crear una tabla en la base de datos correspondiente al cursor dado.

    :param conexion: (SQLite3) Un objeto de SQLite3 para manejar la base de datos
    :param tabla: (str) El nombre de la tabla
    :param campos: (dict) Un diccionario con el formato {'campo':'tipo_de_campo'}
    :return: None
    '''

    cursor = await conexion.cursor()

    _campos = ""

    # Creamos el string para la creacion de la tabla en la base de datos
    for campo, tipo in campos.items():
        if campo=='id_mensaje':
            _campos += f"{campo} {tipo} PRIMARY KEY, "
        else:
            _campos += f"{campo} {tipo} ,"

    _campos = f"({_campos[:-2]})"  # Sacamos la ultima coma

    _tabla = f"CREATE TABLE {tabla}"

    tabla_str = f"{_tabla} {_campos}"

    print("1111:",tabla_str)
    # tabla_str = tabla_str + ' CONSTRAINT id_mensaje_pk PRIMARY KEY (id_mensaje)'
    try:
        await cursor.execute(tabla_str)  # Ejecutamos la creacion de la tabla
    except Exception as error:
        if f'table {tabla} already exists' in str(error):
            return

    await conexion.commit()


async def insertar(conexion, tabla, *values):
    '''
    Funcion que se encarga de insertar en una tabla dada los campos otorgados.

    :param conexion: (SQLite3) Un objeto de SQLite3 para manejar la base de datos
    :param tabla: (str) El nombre de la tabla
    :param values: (list) Una lista con los valores a insertar en la tabla.
    :return: None
    '''

    try:
        cursor = await conexion.cursor()

        values = f"({str(values).rstrip(',)').lstrip('(')})"

        insertar_str = f"INSERT INTO {tabla} VALUES {values}"

        await cursor.execute(insertar_str)

        await conexion.commit()

        return cursor.lastrowid

    except:
        return None


async def obtener_todos(conexion, tabla):
    '''
    Esta funcion se encarga de obtener todos los registros de una tabla dada.

    :param conexion: (SQLite3) Un objeto de SQLite3 para manejar la base de datos
    :param tabla: (str) El nombre de la tabla
    :return: (list) Una lista con los resultados de la query
    '''

    cursor = await conexion.cursor()

    await cursor.execute(f"SELECT rowid,* FROM {tabla}")

    registros = await cursor.fetchall()

    return registros


async def obtener_pendientes(conexion):
    '''
    Esta funcion se encarga de obtener los mensajes que se encuentran con estado 'pendiente' para enviar al servidor.

    :param conexion: (SQLite3) Un objeto de SQLite3 para manejar la base de datos
    :return:
    '''

    cursor = await conexion.execute("SELECT * FROM mensajes WHERE estado='pendiente'")

    registros = await cursor.fetchall()

    return registros


async def actualizar_estado_mensaje(conexion, id_mensaje, estado):
    '''
    Esta funcion se encarga de actualizar el estado de un mensaje dado.
    :param conexion: (SQLite3) Un objeto de SQLite3 para manejar la base de datos
    :param id_mensaje: (str) La id unica de un mensaje de WhatsApp
    :param estado: (str) El estado de un mensaje
    :return:
    '''

    cursor = await conexion.cursor()

    actualizar_str = "UPDATE mensajes SET estado=? WHERE id_mensaje=?"

    await cursor.execute(actualizar_str, (estado, id_mensaje))

    await conexion.commit()


async def obtener_mensajes_a_enviar(conexion):
    '''
    Esta funcion se encarga de obtener todos los mensajes para enviar a traves de selenium.

    :param conexion: (SQLite3) Un objeto de SQLite3 para manejar la base de datos
    :return:
    '''

    cursor = await conexion.execute("SELECT rowid,* FROM fila WHERE estado=?", ['pendiente'])

    registros = await cursor.fetchall()

    return registros


async def obtener_id_ultimo_mensaje(conexion, telefono):
    '''
    Esta funcion se  encarga de obtener el id del ultimo mensaje enviado por un usuario.

    :param conexion: (SQLite3) Un objeto de SQLite3 para manejar la base de datos
    :param telefono: (str) El telefono del usuario.
    :return:
    '''

    busqueda = "SELECT * FROM mensajes WHERE telefono=?"

    cursor = await conexion.execute(busqueda, [telefono])

    registros = await cursor.fetchall()

    return registros


async def obtener_usuario(conexion, telefono):
    busqueda = "SELECT * FROM usuarios WHERE telefono=?"

    cursor = await conexion.execute(busqueda, [telefono])

    registro = await cursor.fetchone()

    return registro


async def actualizar_mensaje_fila(conexion, id_mensaje, estado):
    cursor = await conexion.cursor()

    actualizar_str = "UPDATE fila SET estado=? WHERE rowid=?"

    await cursor.execute(actualizar_str, (estado, id_mensaje))

    await conexion.commit()


async def actualizar_contacto(conexion, telefono, nombre_agendado):
    cursor = await conexion.cursor()

    actualizar_str = "UPDATE usuarios SET nombre_agendado=? WHERE telefono=?"

    await cursor.execute(actualizar_str, (nombre_agendado, telefono))

    await conexion.commit()


async def bootstrap_bd():

    print("inicializando base datos")
    conexion = await crear_bd_async()

    await crear_tabla(conexion, 'mensajes', **esq_mensajes)

    await crear_tabla(conexion, 'fila', **esq_fila)

    return conexion


def crear_string_insert(*args, tabla=None):
    """Se encarga de crear un string utilizado para un insert en la base de datos"""

    # print("denro crear:",args)
    values = f"({str(args).rstrip(',)').lstrip('(')})"

    # print("voy a insertar estos valores:",values)
    return f"INSERT INTO {tabla} VALUES {values}"



