import os

from sqlalchemy.ext.automap import automap_base
from sqlalchemy import Column, Table, MetaData, String, Integer
from sqlalchemy import create_engine

ClaseBase = automap_base()

class Mensajes(ClaseBase):
    __tablename__ = "mensajes"

    id_mensaje = Column(String(length=100), primary_key=True, nullable=False)
    telefono = Column(String(length=30), nullable=False)
    nombre_agendado = Column(String(length=50), nullable=False)
    mensaje = Column(String(length=500), nullable=False)
    clase = Column(String(length=10), nullable=False)
    fecha_hora = Column(String, nullable=False)
    estado = Column(String, nullable=False)


class Fila(ClaseBase):
    __tablename__ = 'fila'

    id = Column(Integer, primary_key=True)
    telefono = Column(String(length=30), nullable=False)
    mensaje = Column(String(length=500), nullable=False)
    estado = Column(String(length=10), nullable=False)
    nombre_agendado = Column(String(length=50), nullable=False)
    fecha_hora = Column(String, nullable=False)


class Usuarios(ClaseBase):
    __tablename__ = 'usuarios'

    telefono = Column(String(length=30), nullable=False, primary_key=True)
    nombre_agendado = Column(String(length=50), nullable=False)


def crear_bd():
    """
    Funcion para crear la bd con las respectivas tablas.
    Devuelve las clases de las tablas mapeadas
    """

    ruta_bd = f"{os.getcwd()}/wspbd.db"

    engine = create_engine(f'sqlite:///{ruta_bd}')  # Iniciamos el engine en un archivo .db en la carpeta bd

    # Reflejamos nuestras clases en la bd, reflejando tambien las ya existentes
    ClaseBase.prepare(engine, reflect=True)

    return ClaseBase


cb = crear_bd()
print(f"{dir(cb.classes)=}")
