import asyncio
import os
import re

from adaptadores.atapis import *
from bd.bdmemoria import *

import time

def deshabilitar_prints():
    sys.stdout = open(os.devnull, 'w')

def timeit(method):
    def timed(*args, **kw):
        ts = time.time()
        result = method(*args, **kw)
        te = time.time()
        if 'log_time' in kw:
            name = kw.get('log_name', method.__name__.upper())
            kw['log_time'][name] = int((te - ts) * 1000)
        else:
            print('%r  %2.2f ms' % (method.__name__, (te - ts) * 1000))
        return result

    return timed


def parsear_bytes(bytes, suffix="B"):
    """
    Escala los bits a un formato dado (MB, GB, KB, etc).
    """
    factor = 1024
    for unit in ["", "K", "M", "G", "T", "P"]:
        if bytes < factor:
            return f"{bytes:.2f}{unit}{suffix}"
        bytes /= factor


def respuesta(estado, respuesta, dato=None):
    return {'Estado': estado,
            'Respuesta': respuesta,
            'Dato': dato}


def borrar_emojis(string):
    """Borra todos los emojis de un string dado"""
    regex = re.compile(pattern="["
                               u"\U0001F600-\U0001F64F"  # emoticons
                               u"\U0001F300-\U0001F5FF"  # symbols & pictographs
                               u"\U0001F680-\U0001F6FF"  # transport & map symbols
                               u"\U0001F1E0-\U0001F1FF"  # flags (iOS)
                               "]+", flags=re.UNICODE)
    return regex.sub(r'', string)
